

// function to add a mixer track with track index set
// baseMarkup -> "BlockMixerTrack" or "PopoverMixerTrack"
function mixerTrack(baseMarkup, trackIndex)
{
	return {
		"+": baseMarkup,
	 	gxViewModel:
		{
			// one view model per track, with index set here in markup
			nsClass: "H4MixerTrackViewModel",
			gxSharedViewModelID: "MixerTrack" + trackIndex,
			mixerTrackIndex: trackIndex,
		},
 	};
}

function presetButton(title)
{
	return {
		"+": "ButtonView.size12",
		gxTitle: title,
		axTitle: "Preset " + title,
		axHelp: "Applies saved preset to mixer tracks",
	};
}

function fadeAllButton(title)
{
	return {
		"+": "ButtonView.size12",
		gxTitle: title,
		axHelp: "Fades all tracks",
	};
}


markup.push({

// MARK: - mixer block

MixerBlock:
{
	"+": "BlockTemplate",
	geNodeClass: "AHMixerNode",
	gxFaceModel: {
		nsClass: "H4MixerBlockFace",
		gxFaceModelKeyPath: "faceModel",
	},
	maximumInputs: 5,	// only allow 5 inputs connections
	gxPopoverInfo: "MixerPopover",
	gxVerticalTitle: true,
	gxLibraryDescription: "Mix up to 5 different sources",
	gxLibraryIcon: "library.mixer",
	gxTitle: "Mixer",
	gxSocketView: "MixerSocketView",
	gxChildViews:
	{
		stackView:
		{
			nsClass: "GXStackView",
			gxDefaultValue: true,	// expanded
			gxSpacedHeight: 92,
			gxLayout: [
				"V:|-14-[self]",
				"H:|-0-[self]-16-|",
			],
			gxChildViews:
			[
				// the 5 tracks
				mixerTrack("BlockMixerTrack", 0),
				mixerTrack("BlockMixerTrack", 1),
				mixerTrack("BlockMixerTrack", 2),
				mixerTrack("BlockMixerTrack", 3),
				mixerTrack("BlockMixerTrack", 4),
			],
		}
	}
},

	
MixerSocketView:
{
	"+": "SocketView",
	gxIndicatorPainter:
	{
		"+": "LabelFore.boldWeight.size10",
		input0: { gxDefaultString: "1" },
		input1: { gxDefaultString: "2" },
		input2: { gxDefaultString: "3" },
		input3: { gxDefaultString: "4" },
		gxDefaultString: "5",
		gxFontColor: "ForeColorTheme1",
		active : {
			gxFontColor: "BlackColor",
		},
		gxEdgeInsets: "1.5, 1.5, 1.5, 1.5",
	},
},

	
// MARK: - one block face track

BlockMixerTrack:
{
	nsClass: "GXDrawView",
	gxViewName: "trackGroup",
	gxLayout: [
		"V:|-(-999)-[self(16)]",		// vertical position set by parent
		"H:|-11-[self]-11-|",
		"H:|-8-[volumeSlider]-8-|",
		"V:|-0-[volumeSlider(16)]",
	],
	gxChildViews:
	{
		volumeSlider: {
			"+": "SliderView.blockFace.smallKnob",
			axTitleKeyPath: "axTrackDescription",
			axRoleDescription: "Volume Slider",
			//axDescriptionKeyPath: "axTrackDescription",
			axFormatter: "PercentFormatter",
		},
	}
},

// MARK: - one popover track

PopoverMixerTrack:
{
	nsClass: "GXDrawView",
	gxViewName: "trackGroup",
	gxBackPainter: "GroupViewBack",
	axIsIgnored: false,
//	axTitleKeyPath: "displayName",
	axDescriptionKeyPath: "axTrackDescription",
	axRoleDescription: "Track Group",
	axHelp: "Contains mixer settings for one input to this block",
	gxLayout: [
		"V:|-(-999)-[self]",		// vertical position set by parent
		"H:|-0-[self]-0-|",
			   
		"H:|-14-[trackNumber(14)]-4-[sourceName]-12-|",
		"H:|-14-[fadeMinBtn(52)]-10-[volumeBtn(20)]-7-[volumeSlider(180)]-1-[volumeReadout(36)]-12-[fadeMaxBtn(60)]-8-[soloBtn(40)]-12-[leftLabel]-6-[panSlider(76)]-6-[rightLabel]&alignCenterY",
			   
		"V:|-11-[trackNumber(20)]",
		"V:|-11-[sourceName(20)]-8-[volumeBtn(20)]-13-|",
			   
		"V:[panReadout]-(-2)-[panSlider]&alignCenterX",
	],
	gxChildViews:
	{
		trackNumber: labelView("Track:", "left"),
		sourceName: {
			"+": "LabelView.left.smallerSourceIcon.foreColor1.mediumWeight.useMarkup",
			axTitle: "Track Source",
			axIsIgnored: false,
		},
		fadeMinBtn:
		{
			"+": "ButtonView.size11.useMarkup",
			gxTitle: "<icon12.foreColor1.mixer.fade.arrow.down/> 0%",
			gxIntrinsicHeight: 21,
			gxBaselineOffset: -7,
			axTitle: "Fade to 0%",
		},
		volumeBtn:
		{
			"+": "ImageButtonView",
			gxToolTip: "Mute this track",
			gxOnToolTip: "Unmute this track",
			gxButtonType: "toggle",
			axTitle: "Mute",
		},
		volumeSlider:
		{
			"+": "SliderView",
			gxDefaultValue: 1,
			axTitle: "Volume",
			axFormatter: "PercentFormatter"
		},
		volumeReadout:
		{
			"+": "ReadoutView.centery",
			gxIntrinsicHeight: 12,
			gxFormatter: "PercentFormatter"
		},
		fadeMaxBtn:
		{
			"+": "ButtonView.size11.useMarkup",
			gxTitle: "<icon12.foreColor1.mixer.fade.arrow.up/>\u2009100%",	// \u2009 is 'thin space'
			gxIntrinsicHeight: 21,
			gxBaselineOffset: -7,
			axTitle: "Fade to 100%",
		},
		soloBtn:
		{
			"+": "ButtonView.size11",
			gxTitle: "Solo",
			gxIntrinsicHeight: 21,
			gxBaselineOffset: -7,
		},
		leftLabel: labelView("L", "mediumWeight.centery.size11"),
		panSlider:
		{
			"+": "SliderView",
			gxRangeMin: -1,
			gxRangeMax: 1,
			gxDefaultValue: 0,
			gxDetents: "(0)",
			axTitle: "Pan",
			axFormatter: "PercentFormatter"
		},
		rightLabel: labelView("R", "mediumWeight.centery.size11"),
		panReadout:
		{
			"+":  "LabelView.colorThemeLive2.size11",
			gxIntrinsicWidth: 40,
			gxFormatter: "PercentFormatter",
		},
	}
},
	
// MARK: - popover

MixerPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Mixer",
	gxLayout: [
		"H:|-12-[self(570)]-12-|",
		"V:|-12-[self]-12-|",
		"V:|-41-[stackView]-0-[presets]-12-|",
		"H:|-0-[stackView]-0-|",
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		stackView:
		{
			nsClass: "GXStackView",
			gxDefaultValue: true,	// expanded
			gxTopHeight: 4,
			gxInterItemHeight: -1,
			gxExtraSize: 4,
			gxChildViews:
			[
			 	// the 5 tracks
			 	mixerTrack("PopoverMixerTrack", 0),
			 	mixerTrack("PopoverMixerTrack", 1),
			 	mixerTrack("PopoverMixerTrack", 2),
			 	mixerTrack("PopoverMixerTrack", 3),
			 	mixerTrack("PopoverMixerTrack", 4),
			]
		},
		presets:
		{
			nsClass: "GXDrawView",
			gxLayout: [
				"H:|-0-[self]-0-|",
					   
				"V:|-8-[multiLabel]-4-[fadeAllMinBtn]-1-|&alignLeft",	// sets height
				"V:[presetsLabel]-5-[btnA]&alignLeft",

				"H:|-14-[fadeAllMinBtn(108)]-8-[fadeAllMaxBtn(114)]-(>=12)-[btnA(30)]-8-[btnB(30)]-8-[btnC(30)]-8-[btnD(30)]-8-[btnE(30)]-8-[fadePresetsMenu(100)]-14-|&alignBaseline",
			],
			gxChildViews:
			{
				multiLabel: labelView("Multi-Track Fade"),
				presetsLabel: labelView("Volume Group Presets"),
				
				fadeAllMinBtn: fadeAllButton("Fade All to 0%"),
				fadeAllMaxBtn: fadeAllButton("Fade All to 100%"),

				btnA: presetButton("A"),
				btnB: presetButton("B"),
				btnC: presetButton("C"),
				btnD: presetButton("D"),
				btnE: presetButton("E"),
				
				fadePresetsMenu: {
					"+": "FadesetPopupMenu",
					gxBaselineOffset: 6,
				},
			},
		},
	},
},
				

FadesetPopupMenu:
{
	"+": "PopupMenuTemplate.size12",
	gxPullsDown: true,
	gxHideOnNil: false,
	axIsIgnored: false,
	axTitle: "Save as Preset",
	gxMenuItems:
	[
		{	gxTitle: "-Save Preset",      gxValue: "-" },
		{	gxTitle: "Save as Preset A",  gxValue: "A" },
		{	gxTitle: "Save as Preset B",  gxValue: "B" },
		{	gxTitle: "Save as Preset C",  gxValue: "C" },
		{	gxTitle: "Save as Preset D",  gxValue: "D" },
		{	gxTitle: "Save as Preset E",  gxValue: "E" },
	]
},


})
